/*
 * global.h
 *
 * Created 7/1/2009 By Johnny Huynh
 *
 * Version 00.00.01 7/1/2009
 *
 * Copyright Information:
 * All content copyright  2009 Johnny Huynh. All rights reserved.
 */
 
 #ifndef GLOBAL_H
 #define GLOBAL_H
 
 // standard floating-point error offset
 #ifndef EPSILON
 #define EPSILON 0.00001f
 #endif // EPSILON
 
 // (1 / EPSILON) / 100
 #ifndef EPSILON_INVERSE
 #define EPSILON_INVERSE 1000.0f
 #endif // EPSILON_INVERSE
 
 // collision interpolation extent floating-point error
 // offset
 #ifndef EPSILON2
 #define EPSILON2 0.001f
 #endif // EPSILON2
 
 #if INTERPOLATE_GRADUALLY == 1
 // collision interpolation floating-point error offset
 // The smaller EPSILON3 is, the fewer calculations are
 // performed per round of collision detection before
 // the scene is rendered (i.e. the larger EPSILON2 is,
 // the more interpolation will be apparent to the user).
 #ifndef EPSILON3
 #define EPSILON3 0.1f
 #endif // EPSILON3
 #endif INTERPOLATE_GRADUALLY == 1
 
 #include <ctime>
 #include "macro.h"
 
 /**
  * The typename used for this program
  */
 #ifndef USER_TYPE
 #define USER_TYPE GLfloat
 #endif // USER_TYPE
 
 namespace global 
 {
    GLfloat time( 1.0f );
    GLboolean enableBoundingSphere( false );
    GLboolean enableAABB( false );
    GLboolean enableConvexHull( false );
    GLboolean testCollision( false );
    
    clock_t elapsedTime( 0 );
    GLint elapsedFrame( 0 );
    GLfloat base_fps( 60.0f );
    GLfloat fps( 1.0f );
    GLfloat speed_factor( 60.0f ); // base_fps / fps
 }
 
 #endif // GLOBAL_H